/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.hbase.collector.HBaseClientAggregator;
import com.lubanops.apm.plugin.hbase.collector.HBaseClusterAggregator;
import com.lubanops.apm.plugin.hbase.collector.HBaseServerNodeAggregator;
import java.util.Map;

public class HBaseCollector
extends Collector {
    public static final HBaseCollector INSTANCE = new HBaseCollector();
    public static final HBaseClientAggregator HBASE_CLIENT_AGGREGATOR = new HBaseClientAggregator();
    public static final HBaseServerNodeAggregator HBASE_SERVER_NODE_AGGREGATOR = new HBaseServerNodeAggregator();
    public static final HBaseClusterAggregator HBASE_CLUSTER_AGGREGATOR = new HBaseClusterAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();
    private static int maximumVarargsLength = 500;
    private static int maximumProtobufRequestLength = 800;
    private static int maximumBatchRowListCount = 5;

    public void parseParameter(Map<String, String> parameters) {
    }

    public static void onStart(String tableWithNamespace, String command) {
        HBASE_CLIENT_AGGREGATOR.onStart(tableWithNamespace, command);
    }

    public static void onRequestError(String errorTraceId) {
        HBASE_CLIENT_AGGREGATOR.onError(errorTraceId);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void onFinally() {
        HBASE_CLIENT_AGGREGATOR.onFinally();
    }

    public static void rpcCallOnStart(String serverAddr) {
        HBASE_SERVER_NODE_AGGREGATOR.onStart(serverAddr);
        HBASE_CLUSTER_AGGREGATOR.onStart();
    }

    public static void rpcCallOnError(String errorTraceId) {
        HBASE_SERVER_NODE_AGGREGATOR.onError(errorTraceId);
        HBASE_CLUSTER_AGGREGATOR.onError(errorTraceId);
    }

    public static void rpcCallOnFinally() {
        HBASE_SERVER_NODE_AGGREGATOR.onFinally();
        HBASE_CLUSTER_AGGREGATOR.onFinally();
    }

    public static void incrementQueryRowCount(long count) {
        HBASE_CLIENT_AGGREGATOR.incrementQueryRowCount(count);
    }

    public static void incrementUpdateRowCount(long count) {
        HBASE_CLIENT_AGGREGATOR.incrementUpdateRowCount(count);
    }

    public static int getMaximumVarargsLength() {
        return maximumVarargsLength;
    }

    public static void setMaximumVarargsLength(int maxLength) {
        maximumVarargsLength = maxLength;
    }

    public static int getMaximumProtobufRequestLength() {
        return maximumProtobufRequestLength;
    }

    public static void setMaximumProtobufRequestLength(int maxLength) {
        maximumProtobufRequestLength = maxLength;
    }

    public static void setDriverVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public static int getMaximumBatchRowListCount() {
        return maximumBatchRowListCount;
    }

    public static void setMaximumBatchRowListCount(int maxLength) {
        maximumBatchRowListCount = maxLength;
    }

    public String getCollectorName() {
        return "HBase";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)HBASE_CLIENT_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)HBASE_SERVER_NODE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)HBASE_CLUSTER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

