/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.HBaseContext;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import com.lubanops.apm.plugin.hbase.stats.HBaseClusterStats;
import java.util.Map;
import org.apache.hadoop.hbase.client.ClusterConnection;

public class HBaseClusterAggregator
extends SinglePrimaryKeyAggregator<HBaseClusterStats> {
    public static final String CLUSTER_ID = "clusterId";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<HBaseClusterStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart() {
        if (!this.isEnable) {
            return;
        }
        ClusterConnection connection = HBaseContext.CONNECTION_LOCAL.get();
        String clusterId = HBaseUtils.getClusterIdFromConnection(connection);
        if (clusterId != null && !clusterId.equals("unknown")) {
            HBaseClusterStats stats = (HBaseClusterStats)this.getValue(clusterId);
            if (stats.getConnection() == null) {
                stats.setConnection(connection);
            }
            long startTime = stats.onStart();
            this.statsLocal.set(stats);
            this.startTimeLocal.set(startTime);
        }
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        HBaseClusterStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        HBaseClusterStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.set(null);
        this.startTimeLocal.set(null);
        this.errorLocal.set(null);
    }

    protected Class<HBaseClusterStats> getValueType() {
        return HBaseClusterStats.class;
    }

    public String getName() {
        return "cluster";
    }

    protected String primaryKey() {
        return CLUSTER_ID;
    }
}

