/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.interceptor;

import com.datastax.driver.core.Cluster;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.cassandra3.CassandraUtils;
import com.lubanops.apm.plugin.cassandra3.HostToClusterMapper;
import com.lubanops.apm.plugin.cassandra3.SessionHolder;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraCollector;
import java.security.ProtectionDomain;

public class SessionManagerConInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            CassandraCollector.onException(e);
        }
        catch (Exception initException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)initException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (object != null) {
                Cluster cluster = (Cluster)((AttributeAccess)object).getLopsFileds()[0];
                String hosts = CassandraUtils.getClusterHosts(cluster);
                TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"hosts", (Object)hosts);
                HostToClusterMapper.save(hosts.split(","), hosts);
                int sessionId = SessionHolder.register(object);
                if (sessionId > 0) {
                    TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"sessionId", (Object)sessionId);
                }
            }
        }
        catch (Exception initException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)initException);
        }
    }

    static {
        try {
            CassandraCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)Cluster.class.getProtectionDomain()));
        }
        catch (NoClassDefFoundError e) {
            CassandraCollector.setDriverVersion("unknown");
        }
    }
}

